// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Lab 6: To design a Lag Compensator by Root-Locus technique

clc ;
clear all;

s=%s;
G=syslin('c',1/(s*(s+1)*(s+4))) // Transfer Function of Un-Compensated System
Gc=syslin('c',(s+0.2)/((s+0.02)*s*(s+1)*(s+4))) // Transfer Function of Compensated System
// Root - Locus of Un-Compensated System
figure(0)
clf, evans(G), xgrid//(5, 1, 7)
replot([-4.5,-10,0.5,10])
// Step Response of Un-Compensated System
figure(1)
t= 0:0.1:100;
x=[csim('step',t,G/(1+G),[0;0;0])]';
plot2d(t',x),xgrid//(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Un-Compensated System');

// Root - Locus of Compensated System
figure(2)
clf, evans(Gc), xgrid//(5, 1, 7)

replot([-4.5,-6,0.5,6])
// Step Response of Compensated System
figure(3)
t= 0:0.1:100;
x=[csim('step',t,Gc/(1+Gc))]';
plot2d(t',x),xgrid//(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Compensated System');
